//
//  TTTVideoViewController.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 11/2/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTVideoViewController.h"

@interface TTTVideoViewController (){
        @private NSURL *movieURL;
}

@end

@implementation TTTVideoViewController

    @synthesize videoView;
    @synthesize playVideoButton;
    @synthesize recordVideoButton;
    @synthesize exitButton;

    - (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil{
        self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
        if (self) {
            // Custom initialization
        }
        return self;
    }

    - (void)viewDidLoad{
        [super viewDidLoad];
        // Do any additional setup after loading the view.
        NSString* videoPath = [[NSBundle mainBundle] pathForResource:@"Videos.bundle/SampleVideo" ofType:@"MOV"];
        movieURL = [NSURL fileURLWithPath:videoPath];
    }

    - (void)didReceiveMemoryWarning{
        [super didReceiveMemoryWarning];
        // Dispose of any resources that can be recreated.
    }

#pragma - Application-specific methods

    - (IBAction) playVideo:(id)sender{
        MPMoviePlayerViewController *moviePlayer = [[MPMoviePlayerViewController alloc] initWithContentURL:movieURL];
        [self presentMoviePlayerViewControllerAnimated:moviePlayer];
    }

    - (IBAction) recordVideo:(id)sender{
        UIImagePickerController *imagePicker = [[UIImagePickerController alloc] init];
        imagePicker.sourceType = UIImagePickerControllerSourceTypeCamera;
        imagePicker.mediaTypes =   [[NSArray alloc] initWithObjects: (NSString *) kUTTypeMovie, nil];
    
        imagePicker.delegate = self;
        [[UIApplication sharedApplication] setStatusBarHidden:YES];
        [self presentViewController:imagePicker animated:YES completion:nil];

    }

    - (void) imagePickerControllerDidCancel: (UIImagePickerController *) picker {
        [[UIApplication sharedApplication] setStatusBarHidden:NO];
        [picker dismissViewControllerAnimated:YES completion:nil];
    }

    - (void) imagePickerController: (UIImagePickerController *) picker
                didFinishPickingMediaWithInfo: (NSDictionary *) results {
    
        NSURL *moviePathURL = [results objectForKey:UIImagePickerControllerMediaURL];
        NSString *moviePath = [moviePathURL path];
        movieURL = moviePathURL;
        
        //Save in camera roll
        if (UIVideoAtPathIsCompatibleWithSavedPhotosAlbum (moviePath)) {
            UISaveVideoAtPathToSavedPhotosAlbum (moviePath, nil, nil, nil);
        }
        [[UIApplication sharedApplication] setStatusBarHidden:NO];
        [picker dismissViewControllerAnimated:YES completion:nil];
    }

    - (IBAction) exit:(id)sender{
        [self dismissViewControllerAnimated:YES completion:nil];
    }
 
@end
